define([
    'underscore',
    'modules/page/popup/warning-popup-view',
    'text!modules/form/form-confirm-navigation.html',
],
function (_, WarningPopupView, template) {
    'use strict';

    return WarningPopupView.extend({
        'template': _.template(template),
        'id': 'confirm-nav',
        'events': {
            'popupafteropen': 'focusOnHeader',
            'popupafterclose': 'destroy',
            'click .warning-continue-btn': 'continue',
            'click .warning-return-btn': 'returnToForm',
            // closePopup has to be called last for
            // event listeners in form-view-mixin
            // to pick up on view's triggered events
            'click button': 'closePopup',
        },
        'continue': function() {
            this.trigger('confirm-navigate');
        },
        'returnToForm': function() {
            this.trigger('cancel-navigate');
        },
        'templateContext': function() {
            return {warningMessage: this.options.warningMessage};
        },
    });
});
